package com.ifourthwall.dbm.provider.dto.member;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2020/10/9 17:17
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class InsertResidenceMemberDTO extends BaseReqDTO {

    @ApiModelProperty("住户id")
    @NotEmpty(message = PlatformCodeConstants.RESIDENCE_ID_NOT_NULL)
    private String residenceId;

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("不动产id")
    @NotEmpty(message = PlatformCodeConstants.ESTATE_ID_NOT_NULL)
    private String estateId;

    @ApiModelProperty("住户人员姓名")
    private String residenceMemberName;

    @ApiModelProperty("住户人员电话")
    private String residenceMemberPhone;

    @ApiModelProperty("住户人员身份证")
    private String residenceMemberIdCard;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人id")
    private String createBy;
}
