package com.ifourthwall.dbm.provider.dto.member;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: YangPeng
 * @Date: 2020/10/10 15:21
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class DeleteResidenceMemberDTO extends BaseReqDTO {

    @ApiModelProperty("住户人员id")
    private String residenceMemberId;

    @ApiModelProperty("住户id")
    @NotEmpty(message = PlatformCodeConstants.RESIDENCE_ID_NOT_NULL)
    private String residenceId;

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("更新人")
    private String updateBy;
}
