package com.ifourthwall.dbm.provider.dto.employee;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.dbm.provider.dto.PageCommonExTDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2020/10/9 11:28
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryMerchantEmployeePageQuDTO extends PageCommonExTDTO {

    @ApiModelProperty("商户id")
    @NotEmpty(message = PlatformCodeConstants.MERCHANT_ID_NOT_NULL)
    private String merchantId;

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("名称搜索")
    private String nameLike;

    @ApiModelProperty("手机搜索")
    private String phoneLike;

    @ApiModelProperty("开始时间")
    private Date beginTime;

    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("默认逆序 1.倒叙")
    private Integer orderBy;

    @ApiModelProperty("商户人员角色类型(1.业主 2.管理员 3.普通员工)")
    private String merchantEmployeeRoleTypeId;

    @ApiModelProperty("商户人员状态（1.在职 2.离职）")
    private String merchantEmployeeStatus;

}
