package com.ifourthwall.dbm.provider.dto.employee;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: YangPeng
 * @Date: 2020/10/9 11:28
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryMerchantEmployeeInfoDTO extends BaseReqDTO {

    @ApiModelProperty("商户id")
    private String merchantId;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("商户人员姓名")
    private String merchantEmployeeName;

    @ApiModelProperty("商户人员电话")
    private String merchantEmployeePhone;

    @ApiModelProperty("商户人员编号")
    private String merchantEmployeeNumber;

    @ApiModelProperty("商户人员身份证")
    private String merchantEmployeeIdCard;

    @ApiModelProperty("商户人员角色类型(1.业主 2.管理员 3.普通员工)")
    private String merchantEmployeeRoleTypeId;

    @ApiModelProperty("商户人员角色类型(1.业主 2.管理员 3.普通员工)")
    private String merchantEmployeeRoleTypeName;

    @ApiModelProperty("商户人员id")
    private String merchantEmployeeId;

    @ApiModelProperty("不动产id")
    private String estateId;

    @ApiModelProperty("商户人员状态（1.在职 2.离职）")
    private String merchantEmployeeStatusId;

    @ApiModelProperty("商户人员状态（1.在职 2.离职）")
    private String merchantEmployeeStatusName;

    @ApiModelProperty("用户关系id")
    private String userRelationshipId;

}
