package com.ifourthwall.dbm.provider.dto.employee;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: YangPeng
 * @Date: 2020/10/9 11:28
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class DeleteMerchantEmployeeDTO extends BaseReqDTO {

    @ApiModelProperty("商户id")
    @NotEmpty(message = PlatformCodeConstants.MERCHANT_ID_NOT_NULL)
    private String merchantId;

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("商户人员id")
    @NotEmpty(message = PlatformCodeConstants.MERCHANT_EMPLOYEE_ID_NOT_NULL)
    private String merchantEmployeeId;

    private String updateBy;

}
