package com.ifourthwall.dbm.provider.dto.announcement;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/12/21 16:09
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class InsertPropertyPraiseQuDTO implements Serializable {

    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("不动产Id")
    private String estateId;

    @ApiModelProperty("不动产名称")
    private String estateName;

    @ApiModelProperty("userId")
    private String userId;

    @ApiModelProperty("表扬人名")
    private String praiseUserName;

    @ApiModelProperty("表扬人联系方式")
    private String praiseUserPhone;

    @ApiModelProperty("表扬内容")
    private String praiseInfo;

    @ApiModelProperty("不动产类型（1:商户，2：住户）")
    private String estateCategory;

    @ApiModelProperty("商住户人员id")
    private String estateMerchantOrResidenceId;

    @ApiModelProperty("照片url")
    private List<String> picUrl;
}
