package com.ifourthwall.dbm.project.dto.space;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2019/11/2 11:03
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QuerySpaceListByNameDTO implements Serializable {

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 项目空间id
     */
    private String projectSpaceId;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 图片
     */
    private String pictureUrl;

    /**
     * 二维码地址
     */
    private String qrcodeUrl;

    /**
     * 上级空间id
     */
    private String parentProjectSpaceId;

    /**
     * 空间层级
     */
    private Integer projectSpaceLvl;

    /**
     * 空间类型1 区域 2 大楼 3 楼层 4 空间
     */
    private String projectSpaceCategoryId;

    /**
     * 空间标签1公共2租赁3设施4住宅区
     */
    private String projectSpaceTagId;

    /**
     * 空间名称
     */
    private String projectSpaceName;

    /**
     * u3d模型id
     */
    private String u3dModelId;

    /**
     * 排序
     */
    private Integer spaceRank;

    /**
     * 面积平方米
     */
    private String projectSpaceArea;

    /**
     * 完整编码（只有最底层空间有）
     */
    private String detailNo;

    /**
     * 简略编码
     */
    private String briefNo;

    /**
     * 说明
     */
    private String remark;

    /**
     * 创建人(user_id)
     */
    private String createBy;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人(user_id)
     */
    private String updateBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新时间
     */
    private String objectId;

}
