package com.ifourthwall.dbm.project.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author: YangPeng
 * @Date: 2019/11/20 17:24
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class InsertSpaceDTO implements Serializable {

    @ApiModelProperty("操作类型 1.新增  2.修改  3.删除")
    @NotNull(message = PlatformCodeConstants.TASK_OPERATE_TYPE_CANNOT_NULL)
    private Integer Type;

    @ApiModelProperty("上级空间id")
    @NotNull(message = "上级空间id不能为空")
    private String parentProjectSpaceId;

    @ApiModelProperty("图片")
    private String pictureUrl;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("空间层级")
    @NotNull(message = "空间层级不能为空")
    private Integer projectSpaceLvl;

    @ApiModelProperty("空间类型1 区域 2 大楼 3 楼层 4 空间")
    private String projectSpaceCategoryId;

    @ApiModelProperty("空间名称")
    @NotNull(message = "空间名称不能为空")
    private String projectSpaceName;

    @ApiModelProperty("空间标签1公共2租赁3设施4住宅区")
    private String projectSpaceTagId;

    @ApiModelProperty("面积平方米")
    private String projectSpaceArea;

    @ApiModelProperty("完整编码（只有最底层空间有）")
    private String detailNo;
}
