package com.ifourthwall.dbm.project.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/11/11 10:02
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class GetSpaceFourQueryDTO extends TranslationDTO {

    @ApiModelProperty(value = "项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty(value = "第四级空间id")
    @NotNull(message = "空间id不能为空")
    private List<String> spacePid;

}
