package com.ifourthwall.dbm.project.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.project.dto.*;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/11/25 13:55
 * @Description:
 */
public interface ZoneFacade  {

    /**
     * 查询区域列表
     * @Author: YangPeng
     * @Date: 2019/11/25 13:55
     * @param getZoneList
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.project.dto.GetZoneListDTO>>
     * @throws
     */
    BaseResponse<List<GetZoneListDTO>> getZoneList(GetZoneListQueryDTO getZoneList);

    /**
     * 查询区域详情
     * @Author: YangPeng
     * @Date: 2019/11/25 15:18
     * @param getZoneInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.GetZoneListDTO>
     * @throws
     */
    BaseResponse<GetZoneListDTO> getZoneInfo(GetZoneInfoQueryDTO getZoneInfo);

    /**
     * 查询所有区域列表（含子区域）
     * @Author: WTK
     * @Date: 2021/6/17 16:17
     * @param getZoneListAll
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<List<GetZoneListAllDTO>> getZoneListAll(GetZoneListAllQueryDTO getZoneListAll);
}
