package com.ifourthwall.dbm.project.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;

/**
 * @Author: YangPeng
 * @Date: 2021/6/15 15:55
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class UpInsertProjectArchiveDTO extends BaseReqDTO {

    @ApiModelProperty("类型 1.新增 2.修改")
    @NotNull(message = "操作类型不能为空")
    private Integer type;

    @ApiModelProperty("项目id")
    @NotNull(message = "项目id不能为空")
    private String projectId;

    @ApiModelProperty("项目档案id")
    private String projectArchiveId;

    @ApiModelProperty("json内容")
    private String jsonContent;

    @ApiModelProperty("是否有效 0 - 生效 1 - 未生效 2 - 删除")
    private String valid;

    @ApiModelProperty("创建者(user_id)")
    private String createBy;

    @ApiModelProperty("更新者(user_id)")
    private String updateBy;

}
