package com.ifourthwall.dbm.project.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: WTK
 * @Date: 2021/11/2 14:15
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryProjectStatisticsPageDTO implements Serializable {

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private String projectId;

    /**
     * 项目编号（6位）
     */
    @ApiModelProperty("项目编号")
    private String projectCode;

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projectName;

    /**
     *   状态（1:启用，2:停用）
     */
    @ApiModelProperty("  状态（1:启用，2:停用）")
    private String projectStatusId;

    /**
     * 项目详细地址
     */
    @ApiModelProperty("项目详细地址")
    private String projectAddress;

    @ApiModelProperty("负责人，对应userid")
    private String projectLeaderUserId;

    /**
     * 负责人名字
     */
    @ApiModelProperty("负责人名字")
    private String projectLeaderUserName;

    /**
     * 负责人电话
     */
    @ApiModelProperty("负责人电话")
    private String ProjectLeaderUserPhone;

    /**
     * 建筑面积
     */
    @ApiModelProperty("建筑面积")
    private BigDecimal buildingArea;

    /**
     * 收费面积
     */
    @ApiModelProperty("收费面积")
    private BigDecimal chargeArea;

    /**
     * 业态(1:园区、2:工业、3:住宅、4:商业、5:办公、6:综合体、7: 酒店、8:学校、9:医院、10:政府、11:租赁式项目、12:自有资产)
     */
    @ApiModelProperty("业态(1:园区、2:工业、3:住宅、4:商业、5:办公、6:综合体、7: 酒店、8:学校、9:医院、10:政府、11:租赁式项目、12:自有资产)")
    private String projectCategoryId;

    /**
     * 优先级1 2 3 4
     */
    @ApiModelProperty("优先级")
    private String projectLvlId;

    /**
     * 项目空间数
     */
    @ApiModelProperty("项目空间数")
    private Integer projectSpaceNumber;

    /**
     * 员工数量
     */
    @ApiModelProperty("员工数量")
    private Integer userStaffNumber;

    /**
     * 机电设备数
     */
    @ApiModelProperty("设备总数")
    private Integer assetNumberAll;

    /**
     * 设施数
     */
    @ApiModelProperty("设施数")
    private Integer facilityNumber;

    /**
     * 商住户数
     */
    @ApiModelProperty("商住户数")
    private Integer merchantResidenceNumber;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;




}
