package com.ifourthwall.dbm.project.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: WTK
 * @Date: 2021/10/8 10:35
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryPageProjectStatisticsDTO  implements Serializable {

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("负责人，对应userid")
    private String projectLeaderUserId;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("项目简称")
    private String projectShortName;

    @ApiModelProperty("项目编号")
    private String projectCode;

    @ApiModelProperty("状态（1:启用，2:停用）")
    private String projectStatusId;

//    @ApiModelProperty("状态名字（1:启用，2:停用，）")
//    private String projectStatusName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("项目空间数")
    private Integer projectSpaceNumber;

    //---服务于项目统计
    @ApiModelProperty("项目地址")
    private String projectAddress;

    @ApiModelProperty("收费面积")
    private BigDecimal chargeArea;

    @ApiModelProperty("建筑面积")
    private BigDecimal buildingArea;

    @ApiModelProperty("业态(1:园区、2:工业、3:住宅、4:商业、5:办公、6:综合体、7: 酒店、8:学校、9:医院、10:政府、11:租赁式项目、12:自有资产)")
    private String projectCategoryId;

    @ApiModelProperty("优先级")
    private String projectLvlId;

}
