package com.ifourthwall.dbm.project.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author: WTK
 * @Date: 2021/6/24 11:45
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class ProjectArchiveDTO implements Serializable {

    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("项目档案id")
    private String projectArchiveId;

    @ApiModelProperty("json内容")
    private String jsonContent;

    @ApiModelProperty("是否有效 0 - 生效 1 - 未生效 2 - 删除")
    private String valid;

    @ApiModelProperty("版本号")
    private String version;

    @ApiModelProperty("创建者(user_id)")
    private String createBy;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新者(user_id)")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

}
