package com.ifourthwall.dbm.project.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author: WTK
 * @Date: 2021/6/25 15:45
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class ProjectArchiveApiDTO implements Serializable {
    //------项目基本-------
    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("项目id")
    private String projectId;

    //1.项目全称-项目名称-projectName  补充：项目简称- projectShortName 2.详细地址-projectAddress 3.项目等级-优先级-projectLvlId 4.项目建筑面积-buildingArea
    //5.委托方全称-业主方-projectBusinessOwner 6.物业类型-业态-projectCategoryId 7.说明备注-备注信息-remark
    //8.合同我方签约主体单位-物业公司名称-propertyMgntCompanyName 9.项目负责人-当前负责人（转名称）-projectLeaderUserName 10.附件url-annexList
    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("项目简称")
    private String projectShortName;

    @ApiModelProperty("项目地址")
    private String projectAddress;

    @ApiModelProperty("优先级1 2 3 4")
    private String projectLvlId;

    @ApiModelProperty("建筑面积")
    private BigDecimal buildingArea;

    @ApiModelProperty("业主方")
    private String projectBusinessOwner;

    @ApiModelProperty("业态(1:园区、2:工业、3:住宅、4:商业、5:办公、6:综合体、7: 酒店、8:学校、9:医院、10:政府、11:租赁式项目、12:自有资产)")
    private String projectCategoryId;

    @ApiModelProperty("备注信息")
    private String remark;

    @ApiModelProperty("物业公司名称")
    private String propertyMgntCompanyName;

    @ApiModelProperty("负责人名字")
    private String projectLeaderUserName;

    @ApiModelProperty("负责人id")
    private String projectLeaderUserId;

    @ApiModelProperty("附件")
    private List<ProjectAnnexQuDTO> projectAnnexList;

//----------项目档案信息----------------
    // 项目档案id-projectArchiveId json内容-jsonContent 版本号-version
    @ApiModelProperty("项目档案id")
    private String projectArchiveId;

    @ApiModelProperty("版本号")
    private String version;

    @ApiModelProperty("json内容")
    private String jsonContent;



}
