package com.ifourthwall.dbm.project.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.project.dto.*;
import com.ifourthwall.dbm.project.dto.project.QueryInfoByObjIdDTO;
import com.ifourthwall.dbm.project.dto.project.QueryInfoByObjIdQuDTO;
import com.ifourthwall.dbm.project.dto.space.*;

import java.util.List;
import java.util.Map;

/**
 * @Author: hao.dai
 * @Date: 2019/10/18 17:26
 * @Description:
 */
public interface ProjectSpaceTwoFacade {

    /**
     * 通过空间名称查询空间信息
     * @Author: YangPeng
     * @Date: 2020/10/21 13:51
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.project.dto.space.QuerySpaceListByNameDTO>>
     * @throws
     */
    BaseResponse<List<QuerySpaceListByNameDTO>> querySpaceListByName(QuerySpaceListByNameQuDTO query);

    /**
     * 查询空间id下的空间信息
     * @Author: YangPeng
     * @Date: 2021/1/20 15:06
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.space.QueryLvlInfoDTO>
     * @throws
     */
    BaseResponse<QueryLvlInfoDTO> queryLvlInfo(QueryLvlInfoBasisQuDTO query);

    /**
     * 根据空间名称搜索空间
     * @Author: YangPeng
     * @Date: 2021/1/21 10:26
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.project.dto.space.QuerySpaceByNameDTO>>
     * @throws
     */
    BaseResponse<List<QuerySpaceByNameDTO>> querySpaceByName(QuerySpaceByNameQuDTO query);

    /**
     * 查询空间完整名称
     * @Author: YangPeng
     * @Date: 2021/3/9 11:37
     * @param newPathBatchQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.project.dto.ProjectSpacePathDTO>>
     * @throws
     */
    BaseResponse<List<ProjectSpacePathDTO>> newSpaceSplit(GetNewPathBatchQueryDTO newPathBatchQueryDTO);

    BaseResponse synchronizeData();
}
