package com.ifourthwall.dbm.project.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/1/2 10:12
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryAllDeptQueryDTO extends PageCommonExTDTO {

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("部门id (web端调用时不用传入)")
    private List<String> deptId;

    @ApiModelProperty("开始时间")
    private String beginTime;

    @ApiModelProperty("结束时间")
    private String endTime;

    @ApiModelProperty("  状态（1:启用，2:停用）")
    private String statusId;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("项目简称")
    private String projectShortName;

    @ApiModelProperty("国家id")
    private Integer countryId;

    @ApiModelProperty("区域id")
    private String zoneId;

    @ApiModelProperty("区域层级")
    private Integer zoneLv;

}
