package com.ifourthwall.dbm.project.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author: WTK
 * @Date: 2021/6/24 14:17
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class ProjectArchiveRecordPageDTO implements Serializable {

    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 项目档案id
     */
    @ApiModelProperty("项目档案id")
    private String projectArchiveId;

    /**
     * 档案记录id
     */
    @ApiModelProperty("档案记录id")
    private String archiveRecordId;

    /**
     * json内容
     */
    @ApiModelProperty("json内容")
    private String jsonContent;

    /**
     * 创建人
     */
    @ApiModelProperty("创建人")
    private String createBy;

    /**
     * 创建人名称
     */
    @ApiModelProperty("创建人名称")
    private String createByName;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("json项目内容")
    private String jsonProject;

    @ApiModelProperty("类型 1.新增 2.修改")
    private String recordType;
}
