package com.ifourthwall.dbm.project.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * @Author: YangPeng
 * @Date: 2019/11/9 11:42
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class GetHomeInfoDTO implements Serializable {

    @ApiModelProperty("区域id")
    private String areaId;

    @ApiModelProperty("区域name")
    private String areaName;

    @ApiModelProperty("楼宇id")
    private String buildingId;

    @ApiModelProperty("楼宇id")
    private String buildingName;

    @ApiModelProperty("楼宇图片")
    private String pics;

    @ApiModelProperty("租赁区数量，需求是只算第四层空间")
    private Integer rentAmount = 0;

    @ApiModelProperty("公共区数量")
    private Integer publicAmount = 0;

    @ApiModelProperty("设施区数量")
    private Integer assetAmount = 0;

    @ApiModelProperty("住户数量")
    private Integer estateAmount = 0;
}
