package com.ifourthwall.dbm.project.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.project.dto.*;
import com.ifourthwall.dbm.project.dto.project.QueryInfoByObjIdDTO;
import com.ifourthwall.dbm.project.dto.project.QueryInfoByObjIdQuDTO;

import java.util.List;
import java.util.Map;

/**
 * @Author: hao.dai
 * @Date: 2019/10/18 17:26
 * @Description:
 */
public interface ProjectSpaceFacade {

    /**
     * 获取空间列表
     *
     * @param
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.ProjectSpaceDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/2 10:57
     */
    BaseResponse<List<ProjectSpaceDTO>> getSpaceFormatList(ProjectSpaceFormatQueryDTO projectId);

    /**
     * 新增修改空间
     *
     * @param projectDTO
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/2 17:42
     */
    BaseResponse<ProjectSpaceBaseDTO> upsertSpace(UpsertSpaceQueryDTO projectDTO);

    /**
     * 通过父级id获取空间列表
     *
     * @param
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List   <   com.ifourthwall.dbm.project.dto.ProjectSpaceBaseDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/6 11:45
     */
    BaseResponse<List<ProjectSpaceBaseDTO>> getSonSpaceList(ProjectSpaceSubListQueryDTO spaceSubListQueryDTO);

    /**
     * 批量新增/修改空间
     *
     * @param projectSpaceList
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/6 11:52
     */
    BaseResponse<List<ProjectSpaceBaseDTO>> upsertSpaceList(List<UpsertSpaceListQueryDTO> projectSpaceList);

    /**
     * 批量获取空间路径信息
     *
     * @param spaceIds
     * @return java.util.List<com.ifourthwall.dbm.project.dto.ProjectSpacePathDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/6 14:27
     */
    BaseResponse<List<ProjectSpacePathDTO>> getSpacePath(SpacePathQueryDTO spaceIds);

    /**
     * 新批量获取空间路径信息-项目维度
     *
     * @param newPathBatchQueryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List   <   com.ifourthwall.dbm.project.dto.ProjectSpacePathDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/6 15:28
     */
    BaseResponse<List<ProjectSpacePathDTO>> getNewPathBatch(GetNewPathBatchQueryDTO newPathBatchQueryDTO);

    BaseResponse<List<ProjectSpacePathDTO>> getObjectPathBatch(GetNewPathBatchQueryDTO newPathBatchQueryDTO);

    /**
     * 获取子空间ids
     *
     * @param sonSpaceQueryDTO
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/6 16:16
     */
    BaseResponse<GetSonSpaceDTO> getSonpace(GetSonSpaceQueryDTO sonSpaceQueryDTO);

    /**
     * 批量删除空间
     *
     * @param deleteSonSpaceQueryDTO
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/6 17:01
     */
    BaseResponse deleteSonSpace(DeleteSpaceQueryDTO deleteSonSpaceQueryDTO);

    /**
     * 批量移动元空间和资产（混合移动）
     *
     * @param spaceDTO
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/7 9:29
     */
    BaseResponse shiftBatchSpace(ShiftBatchSpaceDTO spaceDTO);

    /**
     * 查看空间详情
     *
     * @param spaceId
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/7 15:32
     */
    BaseResponse<ProjectSpaceBaseDTO> querySpaceInfo(QuerySpaceInfoQueryDTO spaceId);

    /**
     * 得到所有项目的所有的id
     *
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/7 15:42
     */
    BaseResponse<QueryAllIdsDTO> queryAllIds();

    /**
     * 查询项目的所有的id
     *
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/7 15:42
     */
    BaseResponse<List<ProjectSpaceBaseDTO>> querySpaceIds(QuerySpaceIdsDTO querySpaceIds);

    /**
     * 根据空间ids查询信息
     *
     * @param ids
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/7 16:09
     */
    BaseResponse<List<ProjectSpaceBaseDTO>> querySpaceByIds(QuerySpaceByIdsQueryDTO ids);

    /**
     * 查询模型集合
     *
     * @param queryDTO
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/7 16:43
     */
    BaseResponse<IFWPageInfo<ProjectSpaceBaseDTO>> queryModelList(QueryModelListQueryDTO queryDTO);

    /**
     * 查询空间名字
     *
     * @param ids
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/8 9:31
     */
    BaseResponse<List<ProjectSpaceBaseDTO>> querySpaceName(QuerySpaceNameQueryDTO ids);


    /**
     * 导入空间
     *
     * @param importSpaceQueryDTO
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/8 9:49
     */
    BaseResponse<ImportSpaceDTO> importSpace(ImportSpaceTopDTO importSpaceQueryDTO);

    /**
     * 空间判空，导表专用
     *
     * @param judgeSpaceDTO
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/8 15:22
     */
    BaseResponse<Map<String, String>> judgeSpace(JudgeSpaceDTO judgeSpaceDTO);

    /**
     * 导入时专用批量更新二维码
     *
     * @param updateQRCodeDTO
     * @return
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/8 15:48
     */
    BaseResponse updateQRCode(UpdateQRCodeDTO updateQRCodeDTO);

    /**
     * 更新模型名称
     *
     * @param upSpaceModelNameDTO
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/8 17:57
     */
    BaseResponse upSpaceModelName(List<UpSpaceModelNameDTO> upSpaceModelNameDTO);

    /**
     * 临时任务查询模型名称
     *
     * @param nameDTO
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/9 9:41
     */
    BaseResponse<ModelNameDTO> queryTemporaryName(TemporaryQueryNameDTO nameDTO);

    /**
     * 获取空间首页信息
     *
     * @param infoDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.GetHomeInfoDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/9 11:44
     */
    BaseResponse<List<GetHomeInfoDTO>> getHomeInfo(GetHomeInfoQueryDTO infoDTO);

    /**
     * 获取空间状态信息
     *
     * @param detailDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.StatusDetailDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/9 15:00
     */
    BaseResponse<StatusDetailDTO> getStatusDetail(StatusDetailQueryDTO detailDTO);

    /**
     * 根据空间id查询对应任务数量(提供项目id及空间id)
     *
     * @param taskInfoBaseDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.StatusDetailDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/9 17:45
     */
    BaseResponse<QueryTaskInfoBaseDTO> queryTaskInfoBase(QueryTaskInfoBaseQueryDTO taskInfoBaseDTO);

    /**
     * 查询子空间的标签
     *
     * @param sonTagDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List   <   com.ifourthwall.dbm.project.dto.QuerySonTagBaseDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/9 18:11
     */
    BaseResponse<QuerySonTagDTO> querySonTag(QuerySonTagQueryDTO sonTagDTO);

    /**
     * 从第四级空间id查询前三个空间信息
     *
     * @param fourSpace
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.GetSpaceFourDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/11 10:05
     */
    BaseResponse<GetSpaceFourDTO> getSpaceFour(GetSpaceFourQueryDTO fourSpace);

    /**
     * 排序
     *
     * @param sortSpace
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2019/11/22 15:41
     */
    BaseResponse sortSpace(SortSpaceQueryDTO sortSpace);

    /**
     * 合并空间
     * @Author: YangPeng
     * @Date: 2019/12/26 10:57
     * @param mergeSacpe
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse spaceMerge(SpaceMergeQueryDTO mergeSacpe);

    /**
     * 查询空间下所有空间id
     *
     * @param spaceId
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.project.dto.QuerySonSpaceListDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/3/30 11:40
     */
    BaseResponse<List<QuerySonSpaceListDTO>> querySonSpaceList(QuerySonSpaceListQuDTO spaceId);

    /**
     * 查询空间下所有空间id
     * @Author: YangPeng
     * @Date: 2020/4/24 10:29
     * @param null
     * @return
     * @throws
     */
    BaseResponse<QueryNextSonListDTO> queryNextSonList(QueryNextSonListQuDTO query);

    /**
     * 查询该空间的父级空间id
     * @Author: YangPeng
     * @Date: 2020/4/24 10:30
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.project.dto.QueryParentSpaceListDTO>>
     * @throws
     */
    BaseResponse<QueryParentSpaceListDTO> queryParentSpaceList(QueryParentSpaceListQuDTO query);

    /**
     * 根据objectId查询描述
     * @Author: YangPeng
     * @Date: 2020/6/28 16:11
     * @param queryInfoByObjIdQuDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.project.dto.project.QueryInfoByObjIdDTO>>
     * @throws
     */
    BaseResponse<List<QueryInfoByObjIdDTO>> queryInfoByObjId(QueryInfoByObjIdQuDTO queryInfoByObjIdQuDTO);


    /**
     * 查询空间列表
     * @Author: YangPeng
     * @Date: 2020/6/28 16:11
     * @param queryInfoByObjIdQuDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.project.dto.project.QueryInfoByObjIdDTO>>
     * @throws
     */
    BaseResponse<List<ProjectSpaceBaseDTO>> getSpaceList(ProjectSpaceSubListQueryDTO queryInfoByObjIdQuDTO);
}
