package com.ifourthwall.dbm.project.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/11/8 14:59
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class UpsertSpaceQueryDTO extends BaseReqDTO {

    @ApiModelProperty("操作类型 1.新增  2.修改  3.删除")
    @NotNull(message = PlatformCodeConstants.TASK_OPERATE_TYPE_CANNOT_NULL)
    private Integer Type;

    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("项目空间id")
    private String projectSpaceId;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("图片")
    private String pictureUrl;

    @ApiModelProperty("二维码地址")
    private String qrcodeUrl;

    @ApiModelProperty("上级空间id")
    private String parentProjectSpaceId;

    @ApiModelProperty("空间层级")
    private Integer projectSpaceLvl;

    @ApiModelProperty("空间类型1 区域 2 大楼 3 楼层 4 空间")
    @NotNull(message = "空间类型不能为空")
    private String projectSpaceCategoryId;

    @ApiModelProperty("空间标签1公共2租赁3设施4住宅区")
    @NotNull(message = "空间标签不能为空")
    private String projectSpaceTagId;

    @ApiModelProperty("空间名称")
    @NotNull(message = "空间名称不能为空")
    private String projectSpaceName;

    @ApiModelProperty("模型ID")
    private String u3dModelId;

    @ApiModelProperty("模型名")
    private String u3dModelName;

    @ApiModelProperty("物件id")
    private String objectId;

    @ApiModelProperty("排序")
    private Integer spaceRank;

    @ApiModelProperty("面积平方米")
    private String projectSpaceArea;

    @ApiModelProperty("完整编码（只有最底层空间有）")
    private String detailNo;

    @ApiModelProperty("简略编码")
    private String briefNo;

    @ApiModelProperty("说明")
    private String remark;

    @ApiModelProperty("创建人(user_id)")
    private String createBy;

    @ApiModelProperty(" 更新人(user_id)")
    private String updateBy;

    @ApiModelProperty("楼层附件")
    private List<ProjectAnnexQuDTO> floorAnnexList;

    @ApiModelProperty("办公附件")
    private List<ProjectAnnexQuDTO> officeAnnexList;


}
