package com.ifourthwall.dbm.asset.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.checkpoint.QueryCheckPointListQueryOneDTO;
import com.ifourthwall.dbm.asset.dto.checkpoint.QueryCheckPointListQueryOneQuDTO;
import com.ifourthwall.dbm.asset.dto.checkpoint.QueryCheckPointTagInfoDTO;
import com.ifourthwall.dbm.asset.dto.checkpoint.QueryCheckPointTagInfoQuDTO;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/5 11:43
 * @Description:
 */
public interface CheckpoinAssetFacade {

    /**
     * 新增点位
     * @Author: YangPeng
     * @Date: 2019/12/5 11:44
     * @param insertCheckpoint
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertCheckpoint(InsertCheckpointQueryDTO insertCheckpoint);

    /**
     * 查询点位列表
     * @Author: YangPeng
     * @Date: 2019/12/5 15:44
     * @param queryCheckPointList
     * @return com.ifourthwall.common.base.BaseResponse<com.github.pagehelper.PageInfo<com.ifourthwall.dbm.asset.dto.QueryCheckPointListDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryCheckPointListDTO>> queryCheckPointList(QueryCheckPointListQueryDTO queryCheckPointList);

    /**
     * 查询点位详情
     * @Author: YangPeng
     * @Date: 2019/12/6 9:33
     * @param checkPointInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.CheckPointInfoDTO>
     * @throws
     */
    BaseResponse<CheckPointInfoDTO> checkPointInfo(CheckPointInfoQueryDTO checkPointInfo);

    /**
     * 删除点位
     * @Author: YangPeng
     * @Date: 2019/12/6 11:44
     * @param deleteCheckPoint
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteCheckPoint(DeleteCheckPointQueryDTO deleteCheckPoint);

    /**
     * 通过部门查询点位相关信息(线上)
     * @Author: YangPeng
     * @Date: 2019/12/18 11:48
     * @param dept
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryByDeptDTO>
     * @throws
     */
    BaseResponse<List<QueryByDeptDTO>> queryByDept(QueryByDeptQueryDTO dept);

    /**
     * 替换checkpointId
     * @Author: YangPeng
     * @Date: 2019/12/31 15:09
     * @param replace
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse replaceCheckpoint(ReplaceCPQuBasisDTO replace);

    /**
     * 解绑checkPointId
     * @Author: YangPeng
     * @Date: 2020/1/8 9:59
     * @param untieCheckpoint
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse untieCheckpoint(UntieCheckpointQuDTO untieCheckpoint);

    /**
     * 绑定checkPointId
     * @Author: YangPeng
     * @Date: 2020/1/8 10:24
     * @param bindCheckpoint
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse bindCheckpoint(BindCheckpointQuDTO bindCheckpoint);

    /**
     * 查询未绑定的点位
     * @Author: YangPeng
     * @Date: 2020/1/8 14:23
     * @param noMac
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.QueryNoMacDTO>>
     * @throws
     */
    BaseResponse<PageDTO<QueryNoMacDTO>> queryNoMac(QueryNoMacQuDTO noMac);

    /**
     * tracker离线包数据
     * @Author: YangPeng
     * @Date: 2020/1/14 17:31
     * @param trackerOffline
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.TrackerOfflineDTO>
     * @throws
     */
    BaseResponse<TrackerOfflineDTO> trackerOffline(TrackerOfflineQuDTO trackerOffline);

    /**
     * 日常任务管理列表
     * @param taskList
     * @return
     */
    BaseResponse<IFWPageInfo<DailyTaskListDTO>> dailyTaskList(DailyTaskListQueryDTO taskList);


    /**
     * 根据mac查询
     * @Author: YangPeng
     * @Date: 2020/3/19 15:45
     * @param dept
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.QueryByDeptDTO>>
     * @throws
     */
    BaseResponse<List<QueryByMacDTO>> queryByMac(QueryByDeptQueryDTO dept);

    /**
     * 批量新增点位
     * @Author: YangPeng
     * @Date: 2019/12/5 11:44
     * @param insertCheckpoint
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertCheckpointList(ExcelCheckPointInfoBasisDTO insertCheckpoint);

    /**
     * 删除点位
     * @Author: YangPeng
     * @Date: 2020/4/8 20:12
     * @param insertCheckpoint
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteCheckPointByProject(DeleteByProjectDTO insertCheckpoint);

    /**
     * 查询点位列表-支持多空间查询
     * @Author: YangPeng
     * @Date: 2020/8/3 10:16
     * @param checkPointList
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.asset.bo.QueryCheckPointListDTO>>
     * @throws
     */
    BaseResponse<List<QueryCheckPointListQueryOneDTO>> queryCheckPointTagList(QueryCheckPointListQueryOneQuDTO checkPointList);

    /**
     * 查询点位标签详情(资产列表)
     * @Author: YangPeng
     * @Date: 2020/8/4 13:53
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.checkpoint.QueryCheckPointTagInfoDTO>
     * @throws
     */
    BaseResponse<List<QueryCheckPointTagInfoDTO>> queryCheckPointTagInfo(QueryCheckPointTagInfoQuDTO query);
}
