package com.ifourthwall.dbm.asset.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.asset.dto.*;

import java.util.List;

/**
 * @Author: hao.dai
 * @Date: 2019/10/23 14:00
 * @Description:
 */
public interface AssetEquipmentFacade {

    /**
     * 新增/修改资产
     * @Author: YangPeng
     * @Date: 2019/12/2 11:04
     * @param upInsertAsset
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertEquipment(UpInsertAssetEquipmentQuDTO upInsertAsset);


    /**
     * 机电设备查询列表
     * @Author: YangPeng
     * @Date: 2020/6/2 16:43
     * @param map
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.asset.dto.QueryAssetEquipmentListDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryAssetEquipmentListDTO>> queryEquipmentList(QueryAssetEquipmentListQuDTO map);

    /**
     * 删除机电设备
     * @Author: YangPeng
     * @Date: 2020/6/5 13:49
     * @param delete
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteEquipment(DeleteEquipmentQueryDTO delete);

    /**
     * 查询机电设备信息
     * @Author: YangPeng
     * @Date: 2020/6/5 14:23
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryEquipmentInfoDTO>
     * @throws
     */
    BaseResponse<QueryEquipmentInfoDTO> queryEquipmentInfo(QueryEquipmentInfoQuDTO query);
}
