package com.ifourthwall.dbm.asset.dto.seer;

import com.ifourthwall.dbm.asset.dto.PageCommonExTDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2020/5/20 15:21
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryTaskSentryAssetListDTO implements Serializable {

    @ApiModelProperty("资产id")
    private String assetId;

    @ApiModelProperty("资产名称")
    private String assetName;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("项目空间id")
    private String projectSpaceId;

    @ApiModelProperty("项目空间名称")
    private String projectSpaceName;

    @ApiModelProperty("图片")
    private String pictureUrl;

    @ApiModelProperty("u3d模型id")
    private String u3dModelId;

    @ApiModelProperty("资产状态 1.正常;2.异常")
    private String assetStatus;

    @ApiModelProperty("资产状态名称")
    private String assetStatusName;

    @ApiModelProperty("资产编号")
    private String assetCode;

    @ApiModelProperty("生产厂家")
    private String factory;

    @ApiModelProperty("资产类型")
    private String assetType;

    @ApiModelProperty("生产日期")
    private Date manufactureDate;

    @ApiModelProperty("资产型号")
    private String assetModel;

    @ApiModelProperty("使用年限")
    private Integer assetLifetime;

    @ApiModelProperty("购买时间")
    private Date purchaseTime;

    @ApiModelProperty("资产原值 元")
    private BigDecimal assetOriginalValue;

    @ApiModelProperty("维保供应商名称")
    private String maintenanceSupplierName;

    @ApiModelProperty("维保供应商电话")
    private String maintenanceSupplierTel;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("创建者user_id")
    private String createBy;

    @ApiModelProperty("创建者名字")
    private String createName;

    @ApiModelProperty("所属系统")
    private String assetTagId;

    @ApiModelProperty("系统名称")
    private String assetTagName;

    @ApiModelProperty("资产工单状态 0.在用;1.维护中；2.停用")
    private String assetTaskStatus;

    @ApiModelProperty("抄表 0.非抄表设备 ; 1.抄表设备")
    private String assetEnableCheckMeter;

    @ApiModelProperty("资产分类0 - 设备 1 - 设施")
    private String assetCategory;

    @ApiModelProperty("资产分类0 - 设备 1 - 设施")
    private String assetCategoryName;

    @ApiModelProperty("是否是特种设备 0.非特种设备 ; 1.特种设备")
    private String specialEquipmentId;

    @ApiModelProperty("资产系统id")
    private String assetSystemId;

    @ApiModelProperty("资产系统名")
    private String systemName;

    @ApiModelProperty("资产类型名")
    private String equipmentTypeName;

    @ApiModelProperty("设备类型id")
    private String assetEquipmentTypeId;

    @ApiModelProperty("资产工单状态")
    private String assetTaskStatusName;

    @ApiModelProperty("系统id")
    private String assetFacilityTagId;

    @ApiModelProperty("系统名称")
    private String assetFacilityTagName;

    @ApiModelProperty("监控对象id")
    private String monitorTargetId;

}
