package com.ifourthwall.dbm.asset.dto.dashboard;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/7/2 09:58
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class DashboardQueryDataQuDTO extends BaseReqDTO {

    @NotNull(message = "数据点id不能为空")
    private List<String> dataPointId;

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    @NotNull(message = "数据统计类型 1.总和 2.折线图")
    private String type;

    @NotNull(message = "总和计算方式 1.累加 2.最后一个累加")
    private String sumType;

    @ApiModelProperty("时间选择 1.今日 2.本周 3.本月")
    private String time;

    @ApiModelProperty("单位")
    private String unit;

}
