package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/26 13:36
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class UpdateAssetListQueryListDTO extends BaseReqDTO {

    @ApiModelProperty("目标空间")
    @NotNull(message = "目标空间不能为空")
    private String aimsSpace;

    @ApiModelProperty("需要合并的空间")
    @NotNull(message = "需要合并的空间不能为空")
    private List<String> mergeSpace;

    @ApiModelProperty("项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("更新者user_id")
    private String updateBy;
}
