package com.ifourthwall.dbm.asset.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2020/3/9 09:50
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class SentryMonitorRankingQuDTO extends BaseReqDTO {

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("时间选择 1.今日 2.本周 3.本月")
    private String time;

    @ApiModelProperty("空间id")
    private String spaceId;

}
