package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/5/20 15:21
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class SeerAssetTagListQuDTO extends BaseReqDTO {

    @ApiModelProperty("空间id")
    private String spaceId;

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("资产类型 0 - 设备 1 - 设施")
    private String assetCategory;

}
