package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/1/7 09:42
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryTagListQuDTO extends PageCommonExTDTO {


    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("系统名称")
    private String assetTagName;

    @ApiModelProperty("模板id")
    private List<String> assetTagIds;



}
