package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/6/5 14:18
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryEquipmentInfoDTO implements Serializable {

    @ApiModelProperty("资产id")
    private String assetId;

    @ApiModelProperty("图片")
    private String pictureUrl;

    @ApiModelProperty("资产名称")
    private String assetName;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("项目空间id")
    private String projectSpaceId;

    @ApiModelProperty("u3d模型id")
    private String u3dModelId;

    @ApiModelProperty("资产编号")
    private String assetCode;

    @ApiModelProperty("生产厂家")
    private String factory;


    @ApiModelProperty("生产日期")
    private Date manufactureDate;

    @ApiModelProperty("资产型号")
    private String assetModel;

    @ApiModelProperty("使用年限")
    private Integer assetLifetime;

    @ApiModelProperty("购买时间")
    private Date purchaseTime;

    @ApiModelProperty("资产原值 元")
    private BigDecimal assetOriginalValue;

    @ApiModelProperty("维保供应商名称")
    private String maintenanceSupplierName;

    @ApiModelProperty("维保供应商电话")
    private String maintenanceSupplierTel;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("设备故障列表")
    private List<FaultItemDTO> FaultItem;

    @ApiModelProperty("设备事件列表")
    private List<MaintenanceItemDTO> MaintenanceItem;

    //3.1.0新增内容

    @ApiModelProperty("资产系统id")
    private String assetSystemId;

    @ApiModelProperty("设备类型id")
    private String assetEquipmentTypeId;

    @ApiModelProperty("资产工单状态 0.在用;1.维护中；2.停用")
    private String assetTaskStatus;

    @ApiModelProperty("抄表 0.非抄表设备 ; 1.抄表设备")
    private String assetEnableCheckMeter;

    @ApiModelProperty("是否是特种设备 0.非特种设备 ; 1.特种设备")
    private String specialEquipmentId;

    @ApiModelProperty("质保到期时间")
    private Date assetQualityMaturityTime;

    @ApiModelProperty("负责人电话")
    private String assetPrincipalPhone;

    @ApiModelProperty("是否自动发起工单 1.发 2不发")
    private String autoCreateTemporaryTaskId;

    @ApiModelProperty("附件")
    private List<AssetAnnexQuDTO> annexList;
}
