package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/3 16:03
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryAssetEquipmentListBasisQuDTO extends PageCommonExTDTO {

    @ApiModelProperty("项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("空间id")
    private String spaceId;

    @ApiModelProperty("是否查询子空间资产 1.查询  默认不查")
    private Integer isOrNot;

    @ApiModelProperty("排序 1逆序，2顺序")
    private String sort;

    @ApiModelProperty("资产名字")
    private String assetName;

    @ApiModelProperty("资产工单状态 0.在用;1.维护中；2.停用")
    private String assetTaskStatus;

    @ApiModelProperty("抄表 0.非抄表设备 ; 1.抄表设备")
    private String assetEnableCheckMeter;

    @ApiModelProperty("是否是特种设备 0.非特种设备 ; 1.特种设备")
    private String specialEquipmentId;

    @ApiModelProperty("资产系统id")
    private String assetSystemId;

    @ApiModelProperty("设备类型id")
    private String assetEquipmentTypeId;

}
