package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/5 10:19
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class InsertCheckpointQueryDTO extends BaseReqDTO {

    @ApiModelProperty("操作类型1新增 2修改")
    private Integer type;

    @ApiModelProperty("资产id")
    private List<CheckPointAssetInfoDTO> assetInfo;

    @ApiModelProperty("部门id")
    private List<String> deptId;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("任务检查点id")
    private String checkPointId;

    @ApiModelProperty("任务检查点空间id")
    @NotNull(message = "任务检查点空间id不能为空")
    private String checkPointSpaceId;

    @ApiModelProperty("任务检查点名字")
    @NotNull(message = "检查点名字不能为空")
    private String checkPointName;

    @ApiModelProperty("绑定设备id 蓝牙mac地址或nfc")
    private String bindingDeviceId;

    @ApiModelProperty("任务检查点描述")
    private String checkPointDesc;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("更新人")
    private String updateBy;

}
