package com.ifourthwall.dbm.asset.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2020/1/4 18:10
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class GodzillaInfoQuDTO extends BaseReqDTO {
    /**
     * 数据点id
     */
    @NotNull(message = "数据点id不能为空")
    private String dataPointId;


    /**
     * 开始时间 yyyy-MM-dd HH:mm:ss
     */
    @NotNull(message = "开始时间不能为空")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    /**
     * 结束时间 yyyy-MM-dd HH:mm:ss
     */
    @NotNull(message = "结束时间不能为空")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date endTime;
}
