package com.ifourthwall.dbm.asset.Util;

public class CheckRegexpUtils {

    /**
     * 前两位英文，后三位数字
     */
    public final static String REG_2SPELL_3NUMBER = "^[a-zA-Z]{2}[0-9]{3}$";

    /**
     * 只要英文和数字
     */
    public final static String REG_SPELL_NUMBER = "^[a-zA-Z0-9]+$";

    /**
     * 只要数字
     */
    public final static String REG_NUMBER = "^[0-9]+$";

    public final static String REG_NUMBER_OR_EMPTY = "^$|^[0-9]+$";

    /**
     * 只要中文，英文，数字
     */
    public final static String REG_NUM_CHAN_ENG = "^[0-9a-zA-Z\\u4e00-\\u9fa5]+$";
    /**
     * 只要中文或
     * @Author: YangPeng
     * @Date: 2019/8/20 13:46
     * @param null
     * @return
     * @throws
     */
    public final static String REG_CHAN_ENG = "^[a-zA-Z\\u4e00-\\u9fa5]+$";

    /**
     * 包含中文，英文，数字，空字符串
     * @Author: xuye
     * @Date: 2019/8/5 9:56
     * @param null
     * @return
     * @throws
     */
    public final static String REG_NUM_CHAN_ENG_EMPTY = "^$|^[0-9a-zA-Z\\u4e00-\\u9fa5]+$";
    public static boolean checkRegexp(String str, String reg) {
        if (str == null) {
            return false;
        }
        return str.matches(reg);
    }

    public static void main(String[]args){
        System.out.println(checkRegexp("等待","^[a-zA-Z\\u4e00-\\u9fa5]+$"));
    }

}
