package com.ifourthwall.dbm.asset.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.asset.dto.dashboard.*;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/6/29 16:16
 * @Description:
 */
public interface DashboardFacade {

    /**
     * 新增仪表盘
     * @Author: YangPeng
     * @Date: 2020/6/29 16:36
     * @param inseret
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertDashboard(InsertDashboardDTO inseret);

    /**
     * 修改仪表盘
     *
     * @param update
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/29 16:14
     */
    BaseResponse updateDashboard(UpdateDashboardDTO update);

    /**
     * 删除仪表盘
     *
     * @param delete
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/29 16:14
     */
    BaseResponse deleteDashboard(DeleteDashboardDTO delete);

    /**
     * 查询仪表盘
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.asset.dto.dashboard.QueryDashboardDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/29 16:14
     */
    BaseResponse<QueryDashboardDTO> queryDashboard(QueryDashboardQuDTO map);

    /**
     * 新增模块
     *
     * @param inseret
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/30 10:26
     */
    BaseResponse insertPanel(InsertDashboardPanelDTO inseret);

    /**
     * 修改模块
     *
     * @param update
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/30 10:26
     */
    BaseResponse updatePanel(UpdatePanelDTO update);

    /**
     * 删除模块
     * @param delete
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/30 10:26
     */
    BaseResponse deletePanel(DeletePanelDTO delete);

    /**
     * 非自定义模块新增
     * @Author: YangPeng
     * @Date: 2020/7/21 10:23
     * @param insertInfo
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertNoCustom(InsertDashboardAndPanelDTO insertInfo);

    /**
     * 查询仪表盘（不包括panel）
     * @Author: YangPeng
     * @Date: 2020/7/21 15:27
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.asset.dto.dashboard.DashboardPanelDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<DashboardPanelDTO>> queryDashboardPanel(QueryDashboardPanelQuDTO query);
}
