package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: YangPeng
 * @Date: 2020/3/17 17:02
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class TagFaultPercentDTO implements Serializable {

    @ApiModelProperty("系统id")
    private String tagId;

    @ApiModelProperty("系统名称")
    private String tagName;

    @ApiModelProperty("设备数")
    private Integer assetNumber;

    @ApiModelProperty("故障率")
    private BigDecimal faultPercent;

    @ApiModelProperty("完好率")
    private BigDecimal normalPercent;
}
