package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: YangPeng
 * @Date: 2020/5/20 15:21
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class SeerAssetTagInfoDTO extends BaseReqDTO {

    @ApiModelProperty("资产id")
    private String assetId;

    @ApiModelProperty("资产名称")
    private String assetName;

    @ApiModelProperty("项目空间id")
    private String projectSpaceId;

    @ApiModelProperty("项目空间名称")
    private String projectSpaceName;

    @ApiModelProperty("sentry异常来源 1.正常;2.异常")
    private String assetStatus;

    @ApiModelProperty("tracker异常来源 1.正常;2.异常")
    private String trackerStatus;

    @ApiModelProperty("资产分类0 - 设备 1 - 设施")
    private String assetCategory;

    @ApiModelProperty("资产分类名称")
    private String assetCategoryName;

    @ApiModelProperty("所属系统")
    private String assetTagId;

    @ApiModelProperty("系统名称")
    private String assetTagName;

    @ApiModelProperty("资产系统id")
    private String assetSystemId;

    @ApiModelProperty("资产系统名")
    private String systemName;

    @ApiModelProperty("资产类型名")
    private String equipmentTypeName;

    @ApiModelProperty("设备类型id")
    private String assetEquipmentTypeId;
}
