package com.ifourthwall.dbm.asset.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.app.UpdateAppIdQuDTO;
import com.ifourthwall.dbm.asset.dto.metric.SentryInsertAlertIdDTO;
import com.ifourthwall.dbm.asset.dto.metric.queryDataPointIdDTO;
import com.ifourthwall.dbm.asset.dto.metric.queryDataPointIdQuDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListQuBasisDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListQuDTO;

import javax.validation.Valid;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 10:45
 * @Description:
 */
public interface MonitorFacade {

    /**
     * 新增修改监控
     * @Author: YangPeng
     * @Date: 2019/12/11 10:46
     * @param upInsertMonitor
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse upInsertMonitor(UpInsertMonitorDTO upInsertMonitor);


    /**
     * 查询监控详情
     * @Author: YangPeng
     * @Date: 2019/12/12 11:13
     * @param querInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryMonitorInfoDTO>
     * @throws
     */
    BaseResponse<QueryMonitorInfoDTO> queryMonitorInfo(QueryMonitorInfoQueryDTO querInfo);

    /**
     * 查询监控翻译配置
     * @Author: YangPeng
     * @Date: 2019/12/16 16:31
     * @param translationDTO
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryMonitorTranslationDTO>
     * @throws
     */
    BaseResponse<QueryMonitorTranslationDTO> queryMonitorTranslation(TranslationDTO translationDTO);

    /**
     * 查询监控列表
     * @Author: YangPeng
     * @Date: 2019/12/17 11:25
     * @param monitorList
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.PageDTO<com.ifourthwall.dbm.asset.dto.QueryMonitorListDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryMonitorListDTO>> queryMonitorList(QueryMonitorListDoQueryDTO monitorList);

    /**
     *查询监控记录列表
     * @Author: YangPeng
     * @Date: 2019/12/19 9:58
     * @param recording
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.PageDTO<com.ifourthwall.dbm.asset.dto.QueryRecordingListDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryRecordingListDTO>> queryRecordingList(QueryRecordingQueryDTO recording);

    /**
     * 根据datapointId查询租户id
     * @Author: YangPeng
     * @Date: 2019/12/20 14:48
     * @param querylist
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryTenantIdDTO>
     * @throws
     */
    BaseResponse<QueryTenantIdDTO> queryTenantId(QueryTenantIdDoQueryDTO querylist);

    /**
     * 接收哥斯拉信息
     * @Author: YangPeng
     * @Date: 2019/12/20 15:13
     * @param dataPoint
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insetMonitorRecord(GetDataPointQueryDTO dataPoint);


    /**
     * 接收哥斯拉信息（更新）
     * @Author: YangPeng
     * @Date: 2019/12/25 9:40
     * @param dataPoint
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse upMonitorRecord(UpMonitorRecordDTO dataPoint);

    /**
     * 通过taskId更新数据
     * @Author: YangPeng
     * @Date: 2020/4/24 20:26
     * @param monitorRecord
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse upMonitorByTaskId(UpMonitorRecordDTO monitorRecord);

    /**
     * 根据datapointId查询
     * @Author: YangPeng
     * @Date: 2020/1/2 15:55
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryDataByMonitorDTO>
     * @throws
     */
    BaseResponse<QueryDataByMonitorDTO> queryDataByMonitor(QueryDataByMonitorQuDTO query);

    /**
     * 存入appid
     * @Author: YangPeng
     * @Date: 2020/1/2 18:08
     * @param insertAppId
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryDataByMonitorDTO>
     * @throws
     */
    BaseResponse insertAppId(InsertAppIdQuDTO insertAppId);

    /**
     * 查询appid
     * @Author: YangPeng
     * @Date: 2020/1/2 20:19
     * @param appId
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<QueryAppIdDTO> queryAppId(QueryAppIdQueryDTO appId);

    /**
     * 通过datePointId查询assetId
     * @Author: YangPeng
     * @Date: 2020/1/13 14:31
     * @param appId
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryAssetByDPDTO>
     * @throws
     */
    BaseResponse<QueryAssetByDPDTO> queryAssetByDP(QueryAssetByDPQuDTO appId);


    /**
     * sentry统计信息
     *
     * @param sentryInfo
     * @param user
     * @return
     */
    BaseResponse<QuerySentryInfoDTO> querySentryInfo(QuerySentryInfoQueryDTO sentryInfo);

    /**
     * sentry统计信息(设备统计)
     * @param sentryInfo
     * @return
     */
    BaseResponse<QuerySentryInfoAssetDTO> querySentryInfoAsset(QuerySentryInfoQueryDTO sentryInfo);

    /**
     * sentry统计信息（7日告警）
     *
     * @param sentryInfo
     * @return
     */
    BaseResponse<QuerySentryInfoSevenDayDTO> querySentryInfoSevenDay(QuerySentryInfoQueryDTO sentryInfo);

    /**
     * sentry统计信息（告警排行）
     *
     * @param sentryInfo
     * @return
     */
    BaseResponse<SentryInfoRankingDTO> querySentryInfoRanking(QuerySentryInfoQueryDTO sentryInfo);

    /**
     * sentry统计信息（设备完好率）
     *
     * @param sentryInfo
     * @return
     */
    BaseResponse<SentryInfoIntactDTO> querySentryInfoIntact(QuerySentryInfoQueryDTO sentryInfo);

    /**
     * seer系统统计列表
     * @param sentryInfo
     * @return
     */
    BaseResponse<IFWPageInfo<SeerTagListDTO>> seerTagList(QuerySentryInfoQueryDTO sentryInfo);

    /**
     * 新增修改监控标签
     * @Author: YangPeng
     * @Date: 2020/4/1 9:44
     * @param sentryInfo
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse upInsertTag(UpInsertTagQuDTO upInsertTag);

    /**
     * 删除监控对象标签
     * @Author: YangPeng
     * @Date: 2020/4/1 10:03
     * @param deleteTag
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteTag(DeleteTagQuDTO deleteTag);

    /**
     * 删除监控
     * @Author: YangPeng
     * @Date: 2020/4/1 14:56
     * @param delete
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteMonitor(DeleteMonitorDTO delete);

    /**
     * 查询监控对象标签
     * @Author: YangPeng
     * @Date: 2020/4/1 16:42
     * @param queryLis
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.asset.dto.QueryMonitorTagListDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryMonitorTagListDTO>> queryTagList(QueryMonitorTagListQuDTO queryLis);

    /**
     * 查询是否引用模板
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Boolean>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/4/17 18:10
     */
    BaseResponse<Boolean> sentryQueryTask(SentryQueryTaskQuDTO query);

    /**
     * 查询AlertId是否存在
     * @Author: YangPeng
     * @Date: 2020/4/20 9:55
     * @param queryAlertId
     * @return java.lang.Boolean
     * @throws
     */
    BaseResponse<Boolean> queryAlertId(QueryAlertIdDTO queryAlertIdDTO);

    /**
     * 查询用电用水信息
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryAllByStatisticsDTO>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/4/22 19:08
     */
    BaseResponse<QueryAllByStatisticsDTO> queryAllByStatistics(QueryAllByStatisticsQuDTO query);

    /**
     * 查询taskId是否存在
     * @Author: YangPeng
     * @Date: 2020/4/24 20:34
     * @param id
     * @return java.lang.Boolean
     * @throws
     */
    BaseResponse<Boolean> queryTaskId(QueryTaskIdQuDTO id);

    BaseResponse<queryDataPointIdDTO> queryDataPointId(queryDataPointIdQuDTO upMonitorRecordDTO);

    /**
     * 查询监控指标详细
     * @Author: YangPeng
     * @Date: 2020/7/22 16:46
     * @param map
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListDTO>>
     * @throws
     */
    BaseResponse<List<QueryEnvironmentListDTO>> queryMonitorMetricList(QueryEnvironmentListQuDTO map);

    /**
     * 根据标签批量查询点位信息
     * @Author: YangPeng
     * @Date: 2020/7/29 10:58
     * @param map
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.seer.QueryEnvironmentListDTO>>
     * @throws
     */
    BaseResponse<List<QueryEnvironmentListDTO>> queryMetricList(QueryEnvironmentListQuBasisDTO map);

    /**
     * 更新appId
     * @Author: YangPeng
     * @Date: 2020/11/17 19:12
     * @param update
     * @return void
     * @throws
     */
    BaseResponse updateAppId(UpdateAppIdQuDTO update);
}
