package com.ifourthwall.dbm.asset.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.dbm.asset.dto.*;
import com.ifourthwall.dbm.asset.dto.seer.QueryTaskSentryAssetListDTO;
import com.ifourthwall.dbm.asset.dto.seer.QueryTaskSentryAssetListQuDTO;

import java.util.List;

/**
 * @Author: hao.dai
 * @Date: 2019/10/23 14:00
 * @Description:
 */
public interface AssetFacade {

    /**
     * 新增/修改资产
     * @Author: YangPeng
     * @Date: 2019/12/2 11:04
     * @param upInsertAsset
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse upInsertAsset(UpInsertAssetQueryDTO upInsertAsset);

    /**
     * 批量删除设备
     * @Author: YangPeng
     * @Date: 2019/12/2 18:11
     * @param deleteAsset
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteAsset(DeleteAssetQueryDTO deleteAsset);

    /**
     * 查询资产列表
     * @Author: YangPeng
     * @Date: 2019/12/3 15:42
     * @param assetList
     * @return com.ifourthwall.common.base.BaseResponse<com.github.pagehelper.Page<com.ifourthwall.dbm.asset.dto.QueryAssetInfoDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryAssetListDTO>> queryAssetList(QueryAssetListQueryDTO assetList);

    /**
     * 通过物件id查询资产列表
     * @Author: YangPeng
     * @Date: 2020/8/24 15:17
     * @param assetList
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.asset.dto.QueryAssetListByObjDTO>>
     * @throws
     */
    BaseResponse<List<QueryAssetListByObjDTO>> queryAssetListByObject(QueryAssetListByObjQueryDTO assetList);

    /**
     * 查询全部配置翻译
     * @Author: YangPeng
     * @Date: 2019/12/3 17:44
     * @param translation
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.AllTranslationDTO>
     * @throws
     */
    BaseResponse<AllTranslationDTO> allTranslation(TranslationDTO translation);

    /**
     * 查询资产详情
     * @Author: YangPeng
     * @Date: 2019/12/4 9:54
     * @param queryAssetInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.QueryAssetInfoDTO>
     * @throws
     */
    BaseResponse<QueryAssetInfoDTO> queryAssetInfo(QueryAssetInfoQueryDTO queryAssetInfo);

    /**
     * 批量修改资产
     * @Author: YangPeng
     * @Date: 2019/12/26 13:45
     * @param updateAssetList
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse updateAssetList(UpdateAssetListQueryListDTO updateAssetList);

    /**
     * 新增/修改系统
     * @Author: YangPeng
     * @Date: 2020/1/6 17:15
     * @param upinTag
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse upinTag(UpinTagQueryDTO upinTag);

    /**
     * 查询标签列表
     * @Author: YangPeng
     * @Date: 2020/1/7 10:18
     * @param queryList
     * @return com.ifourthwall.dbm.asset.dto.PageDTO<QueryTagListBO>
     * @throws
     */
    BaseResponse<PageDTO<QueryTagListDTO>> queryTagList(QueryTagListQuDTO queryList);

    /**
     * 更新系统状态
     * @Author: YangPeng
     * @Date: 2020/1/13 13:48
     * @param upinTag
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse upAssetStatus(UpAssetStatusDTO upinTag);

    /**
     * 批量插入资产
     * @Author: YangPeng
     * @Date: 2020/1/13 13:48
     * @param insert
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertAsset(InsertAssetExcelDTO insert);

    /**
     * 批量插入事件
     * @Author: YangPeng
     * @Date: 2020/1/13 13:48
     * @param insert
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertFaultItem(InsertFaultItemExcelDTO insert);

    /**
     * 批量插入故障
     * @Author: YangPeng
     * @Date: 2020/1/13 13:48
     * @param insert
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertMaintenanceItem(MaintenanceItemExcelDTO insert);

    /**
     * 删除资产
     * @Author: YangPeng
     * @Date: 2020/3/23 16:53
     * @param insert
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse delete(DeleteQuDTO insert);

    /**
     * 删除资产
     * @Author: YangPeng
     * @Date: 2020/3/23 16:53
     * @param insert
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteChecPoint(DeleteQuDTO insert);

    /**
     * 查询该资产在该空间下是否存在
     * @Author: YangPeng
     * @Date: 2020/3/23 16:53
     * @param insert
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<Boolean> queryAssetBySpace(QueryAssetBySpaceDTO query);

    /**
     * 查询未被监控的资产
     * @Author: YangPeng
     * @Date: 2020/3/30 16:49
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.PageDTO<com.ifourthwall.dbm.asset.dto.QueryNoMonitorDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryNoMonitorDTO>> queryNoMonitor(QueryNoMonitorQuDTO query);

    /**
     * 通过项目id删除
     * @Author: YangPeng
     * @Date: 2020/4/8 19:16
     * @param delete
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteByProject(DeleteByProjectDTO query);

    /**
     * 通过assetId查询list
     * @Author: YangPeng
     * @Date: 2020/4/27 14:31
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<List<QueryAssetListByIdsDTO>> queryAssetListByIds(QueryAssetListByIdsQuDTO query);

    /**
     * 查询设备类型
     *
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.asset.dto.QueryEquipmentTypeDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/6/1 15:23
     */
    BaseResponse<List<QueryEquipmentTypeDTO>> queryEquipmentType(QueryEquipmentTypeQuDTO query);

    /**
     * 查询没有被sentry绑定的资产
     *
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.asset.dto.PageDTO < com.ifourthwall.dbm.asset.dto.QueryAssetListDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/7/16 15:02
     */
    BaseResponse<IFWPageInfo<QueryAssetListDTO>> queryNoMonitorAssetList(QueryAssetListQueryDTO map);

    /**
     * 查询资产列表
     * @Author: YangPeng
     * @Date: 2019/12/3 15:42
     * @param assetList
     * @return com.ifourthwall.common.base.BaseResponse<com.github.pagehelper.Page<com.ifourthwall.dbm.asset.dto.QueryAssetInfoDTO>>
     * @throws
     */
    BaseResponse<List<QueryAssetListDTO>> quAssetList(QueryAssetListQueryDTO assetList);

    /**
     * 查询sentry、tracker状态集合的资产列表
     * @Author: YangPeng
     * @Date: 2020/7/30 20:27
     * @param assetList
     * @return com.ifourthwall.common.base.IFWPageInfo<com.ifourthwall.dbm.asset.bo.QueryAssetInfoBO>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryTaskSentryAssetListDTO>> queryTaskSentryAssetList(QueryTaskSentryAssetListQuDTO assetList);
}
