package com.ifourthwall.dbm.asset.dto.checkpoint;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/10/10 18:12
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryCheckPointBySpaceQuDTO extends BaseReqDTO {

    @ApiModelProperty("目标点位id")
    @NotNull(message = PlatformCodeConstants.CHECKPOINT_NOT_NULL)
    private String checkpointId;

    @ApiModelProperty("项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("点位id集合")
    private List<String> checkpointIds;

}
