package com.ifourthwall.dbm.asset.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/11 17:11
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class MonitorMetricBasisDTO implements Serializable {

    @ApiModelProperty("数据点（哥斯拉）")
    private String dataPointId;

    @ApiModelProperty("监控指标描述")
    private String monitorMetricDesc;

    @ApiModelProperty("监控指标名字")
    private String monitorMetricName;

    @ApiModelProperty("指标类型  0. 传感器采集 1. Tracker采集")
    private String metricType;

    @ApiModelProperty("单位")
    private String unit;

    @ApiModelProperty("告警最小值")
    private List<AlertRulesDTO> alarmInfo;

    @ApiModelProperty("哥斯拉设备id")
    private String deviceId;

    @ApiModelProperty("监控对象标签id")
    private String monitorTargetTagId;

    @ApiModelProperty("监控指标抄表最小值")
    private String monitorMetricCheckMeterValueMin;

    @ApiModelProperty("监控指标抄表最大值")
    private String monitorMetricCheckMeterValueMax;
}
