package com.ifourthwall.dbm.asset.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * @Author: YangPeng
 * @Date: 2020/3/2 17:16
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class InsertAssetInfoExcelDTO implements Serializable {

    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("资产id")
    private String assetId;

    @ApiModelProperty("项目id")
    private String projectId;

    /**
     * 所在空间ID
     */
    private String projectSpaceId;

    /**
     * 1:设备；2:设施
     */
    private String assetCategory;

    /**
     * 资产名称
     */
    private String assetName;

    /**
     * 资产编号
     */
    private String assetCode;

    /**
     * u3d模型id
     */
    private String u3dModelId;

    /**
     * 所属系统ID
     */
    private String tagId;

    /**
     * 资产状态1.完好；2异常
     */
    private String assetStatus;

    /**
     * 维保供应商名称
     */
    private String maintenanceSupplierName;

    /**
     * 维保供应商电话
     */
    private String maintenanceSupplierTel;

    /**
     * 规格型号
     */
    private String specifications;

    /**
     * 生产厂家
     */
    private String factory;

    /**
     * 使用年限
     */
    private String assetLifetime;

    /**
     * 资产价值
     */
    private String assetOriginalValue;

    @ApiModelProperty("资产工单状态 0.在用;1.维护中；2.停用")
    private String assetTaskStatus;

    @ApiModelProperty("抄表 0.非抄表设备 ; 1.抄表设备")
    private String assetEnableCheckMeter;

    @ApiModelProperty("是否是特种设备 0.非特种设备 ; 1.特种设备")
    private String specialEquipmentId;

    @ApiModelProperty("设备类型id")
    private String assetEquipmentTypeId;

    @ApiModelProperty("资产系统id")
    private String assetSystemId;

}
