package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;

@Data
@ToString(callSuper=true)
public class ExportExlQueryDTO extends BaseReqDTO {

    @ApiModelProperty("下载类型 1.资产表；2.点位表")
    @NotNull(message = PlatformCodeConstants.OPERATE_TYPE_CANNOT_NULL)
    private Integer type;

    @ApiModelProperty("下载类型 1.设备表；2.设施表")
    @NotNull(message = PlatformCodeConstants.OPERATE_TYPE_CANNOT_NULL)
    private Integer entryType;

    @ApiModelProperty("项目id")
    private String projectId;


}
